"""
KSI 2014/2015, sada 5, uloha 4: V hotelu
Jan Horacek; jan.horacek@seznam.cz
30. 4. 2015
"""

################################################################################

from dijkstra import shortestPath

# Trida reprezentujici mistnosti v hotelu
# lights oznacuje pocet svetel v mistnosti
# neighbours je seznam sousednich mistnosti (index v poli)
class Room(object):
    def __init__(self, num, lights, neighbours):
        self.num = num
        self.lights = lights
        self.neighbours = neighbours

################################################################################

"""
Funkce resici cely problem v hotelu
\rooms je seznam pokoju v hotelu typu Room, vychozi mistnost je indexu 0
\people je seznam cisel pokoju, ve kterych se nachazi lide
Funkce vraci seznam mistnosti v tom poradi, v jakem je
musi rozsvecovat projit tak, aby navstivil osoby ve
stejnem poradi, v jakem jsou v seznamu a zaroven, aby
rozsvitil co nejmene svetel.

Princip reseni problemu:
  Problem resime tak, ze vzdy hledame nejkratsi cestu z daneho pokoje do
  nejblizsi rozsvicene mistnosti. To provadime pomoci Dijkstrova algoritmu.
  Dany pokoj iterujeme pres vsechny pokoje od nulteho az do
  posledniho pokoje. Pro tyto ucely je pokoj rooms[0] ze zacatku vzdy rozsvicen.

  Vystupy Dijsktry pak spolujeme dohromady do jednoho velkeho seznamu :res,
  ve kterem je nakonec cela cesta a ktery vratime.
"""

def find_path(rooms, people):
	G = dict()    # Vytvorime datovou strukturu pro Dijkstru (viz popis v dijkstra.py)
	res = [0]     # Zacatek je vzdy v pokoji 0, proto ho rovnou pridame do vysledne cesty

	# Vytvarime graf: projizdime pokoje:
	for room in range(0, len(rooms)):
		G[room] = [room==0, dict()]         # Jen pokoj 0 je rozsviceny, pozor: na zacatku musi byt alespon jeden pokoj rozsviceny
		for nb in rooms[room].neighbours:   # Pridavame sousedy
			G[room][1][nb] = rooms[nb].lights   # Ohodnoceni hrany = pocet svetel v cilove mistnosti


	# Prochazime cely seznam a hledame nejkratsi cestu vzdy mezi pokojem a nejblizsi rozsvicenou mistnosti
	for p in range(0, len(people)):
		path = shortestPath(G, people[p])   # Viz dijkstra.py
		res.extend(path)                    # Vystup pridame do vysledne cesty
		for room in path: G[room][0] = True # Navstivene pokoje oznacime za rozsvicene

	return res

"""
Casova slozitost:
	Jelikoz tento algoritmus nevyuziva Fibonacciho haldu, jeho casova slozitost
	je O((|E|+|V|)*log|V|).

Pametova slozitost:
	Pametova slozitost je O(|E|+|V|), protoze jednoduse potebujeme ulozit
	cely graf do pameti.

|V| je pocet vrcholu.
|E| je pocet hran.

"""