from task5_4 import Room, find_path
from Tkinter import Tk, Canvas, ALL
import random
import tkFont
import copy

# Testovaci framework pro 4. ulohu.
#
# Spustenim tohoto programu si muzes nechat znazornit,
# jak rozsvecovac rozsvecuje svetla v jednolivych mistnostech
# hotelu dle tveho algoritmu. 

# ---------MODEL MISTNOSTI-----------------------------------------
class RoomModel(Room):
    def __init__(self, width, height, x, y, num, lights, neighbours):
        super(RoomModel, self).__init__(num, lights, neighbours)
        self.width = width
        self.height = height
        self.x = x
        self.y = y

# ---------TESTOVACI DATA------------------------------------------

# Odkomentuj hotel, ktery chces otestovat

# HOTEL 1. - spravne reseni: [0, 1, 3, 5, 4]
"""
hotel = [RoomModel(100, 100, 100, 150, 0, 0, [1]),
         RoomModel(100, 100, 200, 150, 1, 1, [0, 2, 3, 5]),
         RoomModel(150, 100, 300, 150, 2, 2, [1, 4]),
         RoomModel(100, 100, 200,  50, 3, 3, [1]),
         RoomModel(100, 100, 350, 250, 4, 4, [2,5]),
         RoomModel(150, 100, 200, 250, 5, 1, [1,4]),
         ]
people = [3,4]
"""
# HOTEL 2. - spravne reseni: [0, 1, 4, 14, 15, 12, 11, 7, 2]

"""
hotel = [
            RoomModel(50, 50, 50, 250, 0, 1, [1]),
            RoomModel(600, 50, 100, 250, 1, 10, [0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14]),
            RoomModel(100, 100, 100, 150, 2, 2, [1, 3]),
            RoomModel(100, 100, 200, 150, 3, 2, [1, 2]),
            RoomModel(100, 100, 300, 150, 4, 2, [1]),
            RoomModel(100, 100, 400, 150, 5, 2, [1]),
            RoomModel(100, 100, 500, 150, 6, 2, [1, 7]),
            RoomModel(100, 100, 600, 150, 7, 2, [1, 6]),
            RoomModel(100, 100, 100, 300, 8, 2, [1]),
            RoomModel(100, 100, 200, 300, 9, 2, [1]),
            RoomModel(100, 50, 300, 300, 10, 3, [1, 11, 12]),
            RoomModel(100, 50, 300, 350, 11, 2, [10, 12]),
            RoomModel(100, 100, 400, 300, 12, 2, [1, 10, 11]),
            RoomModel(100, 100, 500, 300, 13, 2, [1, 14, 15]),
            RoomModel(100, 50, 600, 300, 14, 1, [1, 13, 15]),
            RoomModel(100, 50, 600, 350, 15, 1, [13, 14])
        ]     

people = [4, 15, 11, 7, 2]
"""

# HOTEL 3. - spravne reseni: [0, 1, 8, 23, 4, 5, 6, 10, 2, 21, 12, 16, 22]

hotel = [RoomModel(90, 40, 710, 440, 0, 1, [1]), 
         RoomModel(600, 40, 110, 440, 1, 5, [0, 2, 3, 5, 7, 16, 17, 18, 19, 8, 9]),
         RoomModel(110, 40, 0, 440, 2, 1, [1, 15, 21]),
         RoomModel(60, 440, 110, 0, 3, 7, [1, 4, 21]),
         RoomModel(480, 40, 170, 100, 4, 4, [3, 5, 23, 22]),
         RoomModel(60, 340, 650, 100, 5, 5, [4, 6, 1, 13, 12, 11, 10]),
         RoomModel(60, 100, 650, 0, 6, 1, [5, 14]),
         RoomModel(150, 90, 170, 350, 7, 2, [1, 8]),
         RoomModel(150, 90, 320, 350, 8, 2, [7, 1, 23]),
         RoomModel(180, 90, 470, 350, 9, 3, [1]),
         RoomModel(90, 60, 710, 380, 10, 2, [5]),
         RoomModel(90, 80, 710, 300, 11, 3, [5]),
         RoomModel(90, 80, 710, 220, 12,3, [13, 5]),
         RoomModel(90, 80, 710, 140, 13, 2, [12, 5, 14]),
         RoomModel(90, 140, 710, 0, 14, 4, [6, 13]),
         RoomModel(100, 120, 0, 480, 15, 4, [16, 2]),
         RoomModel(100, 120, 100, 480, 16, 4, [1, 15]),
         RoomModel(100, 120, 200, 480, 17, 2, [18, 1]),
         RoomModel(200, 120, 300, 480, 18, 5, [17, 1]),
         RoomModel(200, 120, 500, 480, 19, 5, [20, 1]),
         RoomModel(100, 120, 700, 480, 20, 3, [19]),
         RoomModel(110, 250, 0, 190, 21, 6, [2, 3]),
         RoomModel(250, 100, 350, 0, 22, 8, [4]),
         RoomModel(60, 210, 400, 140, 23, 2, [8, 4]),
         ]
people = [1, 4, 6, 10, 21, 12, 16, 22]


# ---------KONEC TESTOVACICH DAT-----------------------------------

# Rozmery okna
WIDTH = 800
HEIGHT = 600

# Konstanty
DOOR_WIDTH = 30
LINE_WIDTH = 5
PERSON_RADIUS = 15

# Inicializace okna
window = Tk()
window.title("Tezka prace rozsvecovace svetel v hotelu")
canvas = Canvas(window, width=WIDTH, height=HEIGHT)
canvas.configure(background="#262626")
canvas.pack()
window.resizable(0, 0)
font = tkFont.Font(family="Helvetica", size=14)

# Spocita stred pruniku zdi pro dvere
def get_door_pos(top1, bottom1, top2, bottom2):
    top = max(top1, top2)
    bottom = min(bottom1, bottom2)
    return (top + bottom) / 2

# Vykreslovaci funkce
def draw_hotel(rooms, light, people):
    canvas.delete(ALL) # ALL je std konstanta z Tk
    for room, idx in zip(rooms, range(len(rooms))):
        if idx in light:
            font_color = "black"
            bg_color = "yellow"
        else:
            font_color = "white"
            bg_color = "dark blue"

        # Draw room
        canvas.create_rectangle(room.x, room.y,
            room.x + room.width, room.y + room.height,
            fill=bg_color, outline="brown", width=LINE_WIDTH)
        # Draw person
        if idx in people:
            x = random.randint(room.x + PERSON_RADIUS + LINE_WIDTH,
                room.x + room.width - PERSON_RADIUS - LINE_WIDTH)
            y = random.randint(room.y + PERSON_RADIUS + LINE_WIDTH,
                room.y + room.height - PERSON_RADIUS - LINE_WIDTH)
            canvas.create_oval(x + PERSON_RADIUS, y + PERSON_RADIUS,
                x - PERSON_RADIUS, y - PERSON_RADIUS, fill="red")
            canvas.create_text(x, y,
                font = font, text=chr(96 + idx), fill="black")
        # Draw number of lights
        canvas.create_text(room.x + room.width / 2, room.y + room.height / 2,
           font = font, text=str(room.lights), fill=font_color)

        # Draw room ID
        # canvas.create_text(room.x + room.width / 2, room.y + room.height / 2,
        #    font = font, text=str(idx), fill=font_color)

        # Draw doors
        for neighbour in room.neighbours:
            n_room = rooms[neighbour]
            if room.y + room.height == n_room.y:
                pos = get_door_pos(room.x, room.x + room.width,
                                    n_room.x, n_room.x + n_room.width)
                x0 = pos - DOOR_WIDTH / 2
                x1 = pos + DOOR_WIDTH / 2
                y0 = n_room.y - LINE_WIDTH
                y1 = n_room.y + LINE_WIDTH
            elif room.y == n_room.y + n_room.height:
                pos = get_door_pos(room.x, room.x + room.width,
                                    n_room.x, n_room.x + n_room.width)
                x0 = pos - DOOR_WIDTH / 2
                x1 = pos + DOOR_WIDTH / 2
                y0 = room.y - LINE_WIDTH
                y1 = room.y + LINE_WIDTH
            elif room.x + room.width == n_room.x:
                pos = get_door_pos(room.y, room.y + room.height,
                                   n_room.y, n_room.y + n_room.height)
                y0 = pos - DOOR_WIDTH / 2
                y1 = pos + DOOR_WIDTH / 2
                x0 = n_room.x - LINE_WIDTH
                x1 = n_room.x + LINE_WIDTH
            elif room.x  == n_room.x + n_room.width:
                pos = get_door_pos(room.y, room.y + room.height,
                                   n_room.y, n_room.y + n_room.height)
                y0 = pos - DOOR_WIDTH / 2
                y1 = pos + DOOR_WIDTH / 2
                x0 = room.x - LINE_WIDTH
                x1 = room.x + LINE_WIDTH
            else:
                print "Neighbours aren't neighbours: " + str(idx) + ":" + str(neighbour)
            canvas.create_rectangle(x0, y0, x1, y1, fill="red", width=5, outline="red")

# Spocteni reseni
result = find_path(copy.deepcopy(hotel), copy.deepcopy(people))


# Hlavni smycka okna
def task():
    global progress
    part_result = result[0:min(len(result), progress)]
    draw_hotel(hotel, part_result, people)
    window.after(1000, task) 
    progress += 1

progress = 0
window.after(10, task)
window.mainloop()
