"""
KSI 2014/2015, sada 5, uloha 1: Prelevani vody
Jan Horacek; jan.horacek@seznam.cz
27. 4. 2015
"""

from collections import deque

################################################################################

"""
Trida State reprezentuje jeden stav stavoveho prostoru.
Tedy zejmena aktualni stav vody v nadobach a stav, ze ktereho jsme se do tohoto
  stavu dostali (tedy "odkaz na rodice").

Pro tuto tridu je klicove, ze porovnavani instanci probiha pouze na zaklade
  stavu kbeliku, nikoliv na zaklade rodice. To se uplatni pri porovnavani nove
  vygenerovanych stavu s uz navstivenymi stavy.
"""
class State:
    def __init__(self, buckets, parent):
        self.buckets = buckets
        self.parent = parent

    def __eq__(self, other):
        if isinstance(other, self.__class__):
            return self.buckets == other.buckets
        else:
            return False

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return hash(self.buckets)

################################################################################

"""
Generace novych stavu z daneho stavu
Algoritmus popsany jednou vetou:
    "Z kazde nadoby s nenulovym objemem vody prelevame do vsech ostatnich nadob"
"""
def generate_new_states(capacities, state):
    res = set()                                         # Seznam generovanych stavu
    for from_bucket in range(0, len(state.buckets)):    # Odkud prelevat
        if state.buckets[from_bucket] == 0: continue    # Nelze prelevat z prazdneho kbeliku

        for to_bucket in range(0, len(state.buckets)):  # Kam prelevat
            if from_bucket == to_bucket: continue       # Je nesmysl prelevat sam sobe

            new = list(state.buckets)                   # Preliti je mozne -> vytvorime novy stav

            # Mnozstvi vody k preliti lze vyjadrit matematickou funkci.
            prelejeme = min(state.buckets[from_bucket], capacities[to_bucket]-state.buckets[to_bucket])

            # Prelijeme
            new[from_bucket] -= prelejeme
            new[to_bucket]   += prelejeme

            res.add(State(tuple(new), state))           # Novy stav pridame do seznamu stavu

    return res

################################################################################

def buckets(capacities, initial_state, final_state):
    """
    Resi ulohu prelevani vody

    Args:
        capacities: n-tice velikosti kbeliku
        initial_state: n-tice udavajici, kolik je vody v kterem kbeliku
        final_state: n-tice urcujici pozadovany cilovy stav vody v kbelicich
    Returns:
        plan reseni ulohy ve forme seznamu stavu (prvni polozka musi byt
        :inital_state: a posledni :final_state:)
    """

    """
    Toto reseni vyuziva tridu State reprezentujici jeden stav cele ulohy.
    Instance si pamatuje obsah jednotlivych nadob a stav, ze ktereho jsme do nej
    prisli. Tento "uakzatel na rodice" se vyuziva pri zpetne rekonstrukci cesty.

    Toto reseni neni nic slozitejsiho, nez prohledavani stavoveho prsotoru do
    sirky. V kazdem stvu si generujeme nove stavy funkci generate_new_states

    """

    visited = set()                                     # Seznam navstivenych vrcholu je set isntanci State
    state = State(initial_state, None)                  # Vytvoritme prvni stav
    queue = deque([state])                              # a vlozime ho do fronty

    while queue:
        state = queue.popleft()

        # Je aktualni stav cilovym stavem?
        if state.buckets == final_state:
            # Ano -> rekonstrukce cesty k pocatecnimu stavu.
            ret = list()                                # Tady si pamatujeme cestu k pocatecnimu stavu
            cur = state
            while cur.parent is not None:               # Prochazime, dokud existuji rodice
                ret.insert(0, cur.buckets)
                cur = cur.parent
            ret.insert(0, initial_state)
            return ret

        # Aktualni stav neni cilovym stavem -> generujeme dalsi stavy a pridavame je do fronty
        if state.buckets not in visited:
            visited.add(state)                          # Stav \state oznacime za zpracovany
            queue.extend(generate_new_states(capacities, state) - visited)
                                                        # a vygenerujeme jeho nasledovniky
                                                        # a davame pozor na uz navstivene stavy.

    # Cesta nebyla nalezena
    return list()
