from task5_1 import buckets

"""
KSI 2014/2015, sada 5, uloha 1
Skript pro overeni spravnosti vasi implementace
"""

# test cases list: each test case is a 4-tuple consisting of capacities,
# initial_state, final_state, solution
TEST_CASES = [
    # test case 1
    ((8, 5, 3), (7, 1, 0), (2, 5, 1), [(7, 1, 0), (7, 0, 1), (2, 5, 1)]),
    # test case 2
    ((8, 5, 3), (3, 2, 3), (4, 4, 0), [(3, 2, 3), (6, 2, 0), (6, 0, 2),
        (1, 5, 2), (1, 4, 3), (4, 4, 0)]),
    # test case 3
    ((5, 10), (3, 7), (3, 7), [(3, 7)]),
    # test case 4
    ((9, 6, 2), (9, 0, 0), (5, 2, 2), [(9, 0, 0), (7, 0, 2), (7, 2, 0),
        (5, 2, 2)]),
    # test case 5
    ((9, 7, 4, 2), (9, 0, 0, 0), (3, 3, 3, 0), [(9, 0, 0, 0), (5, 0, 4, 0),
        (5, 4, 0, 0), (1, 4, 4, 0), (1, 7, 1, 0), (1, 5, 1, 2), (3, 5, 1, 0),
        (3, 3, 1, 2), (3, 3, 3, 0)])
]


def valid_move(from_state, to_state, capacitites):
    """
    Returns True if the move from :from_state: to :to_state: is valid,
    False otherwise. Supposes that the :from_state: is a valid state.
    """
    # check that number of buckets is same
    if len(from_state) != len(to_state):
        return False

    # check water change (should be only between 2 buckets (or 0, although it
    # means the solution will be not optimal) and it should change the total
    # amount of water in the buckets
    water_change = [from_bucket_amount - to_bucket_amount
        for from_bucket_amount, to_bucket_amount in zip(from_state, to_state)
        if from_bucket_amount - to_bucket_amount != 0]
    if len(water_change) not in [0, 2] or sum(water_change) != 0:
        return False

    # check that capacities are not violated
    if any([water_amount > capacity
            for water_amount, capacity in zip(to_state, capacitites)]):
        return False

    return True


#try:
if 1==1:
    for i, (capacities, initial_state, final_state, solution)\
            in enumerate(TEST_CASES):
        print '-' * 80
        print 'Test case {number}'.format(number=i + 1)
        print ('capacities={capacities}, initial_state={init}, '
            + 'final_state={final}'.format(
                capacities=capacities, init=initial_state, final=final_state))

        path = buckets(capacities, initial_state, final_state)
        print 'your path:', path

        # check if the solution is valid
        valid_solution = True

        # check that the path is not empty or None
        if path is None:
            print "No path returned!"
            valid_solution = False
        elif not path:
            print 'Empty path is not valid'
            valid_solution = False
        # check that first state is the initial_state
        elif path[0] != initial_state:
            print 'First state has to be', initial_state
            valid_solution = False
        # check that last state is the final_state
        elif path[-1] != final_state:
            print 'Last state has to be', final_state
            valid_solution = False
        # check that all moves are valid within our rules
        else:
            for i in range(len(path) - 1):
                from_state = path[i]
                to_state = path[i + 1]
                if not valid_move(from_state, to_state, capacities):
                    print 'Invalid move: {from_state} --> {to_state}'\
                        .format(from_state=from_state, to_state=to_state)
                    valid_solution = False

        # if the solution is valid, check if it is optimal
        if valid_solution:
            if len(path) == len(solution):
                print '*optimal solution*'
            elif len(path) > len(solution):
                print 'Not optimal solution.'
                print 'Example of optimal path:', solution
        else:
            print 'Example of valid solution:', solution
    print '-' * 80

#except Exception:
    #raise Exception
    
    #print 'Invalid result! Function buckets() should return list of states' +\
        #' e.g. [(1, 2, 3), (3, 4, 5), ...]', e.Value
