# Doplnte nasledujici sablonu, jinak nic nemente. Staci odevzdat tento soubor,
# zduvodneni spravnosti reseni neni vyzadovano. Pro identifikaci grafu
# vyuzivejte cisla uvedne na kartickach (1, 2, 3, ..., 57, 58)

# Napred vyplnte rozklad grafu na dominech (nejlepe vsech 58) na 9 skupin
# izomorfnich grafu. Pro zjednoduseni ukolu jsme vam u kazde skupiny uz uvedli
# jednoho reprezentanta (toho s nejmensim cislem v dane skupine).
# Vysledny slovnik mapuje reprezentanty na mnozinu jim izomorfnich grafu.
# Reprezentanty (klice slovniku) nemente, pouze doplnte mnoziny. Napr. pokud
# zjistite, ze s grafem 1 jsou izomorfni grafy 11 a 25, doplnte prvni radek
# slovniku nasledovne: 1: {1, 11, 25}.

izomorfismy = {
    1: {1, 21, 31, 36, 39, 48},
    2: {2, 33, 41, 42, 44},
    3: {3, 7, 37, 54},
    4: {4, 5, 19, 22, 27, 38},
    6: {6, 13},
    8: {8, 11, 16},
    9: {9, 17, 20, 34, 46, 47},
    10: {10, 35, 43},
    12: {12, 23, 49},
    14: {14, 24, 40},
    15: {15, 18, 25, 30, 32, 45},
    26: {26, 28, 29},
    50: {50, 52, 56},
    51: {51, 58},
    53: {53, 55, 57}
}

# Vsechny ostatni vlastnosti maji pro skupiny izomorfnich grafu vzdy stejnou
# hodnotu, staci tedy uvest pouze rozklad reprezentantu kazde z 9 izomorfnich
# skupin (jako reprezenanty pouzivejte grafy s nejmensim identifikacnim cislem
# v dane skupine, tj. klice ve slovniku izomorfizmu vyse). Jinymy slovy, v
# nasledujicich rozkladech pouzijte pouze cisla 1, 2, 3, 4, 6, 8, 9, 10, 12,
# 14, 15, 26, 50, 51 a 53.

# Vsechny vlastnosti zachytte pomoci slovniku, ktery mapuje hodnotu vlastnosti
# (napr. pocet vrcholu) na mnozinu reprezentantu.

pocet_vrcholu = {
    4: {6},
    5: {2, 50},
    6: {1, 8, 9, 14, 51},
    7: {3, 26},
    8: {4, 10, 12, 15, 53}
}

nejmensi_stupen_vrcholu = {
    1: {9, 10, 12, 26, 50},
    2: {1, 2, 3, 4, 6, 8, 14, 15, 51, 53},
}

nejvetsi_stupen_vrcholu = {
    2: {2, 6},
    3: {1, 3, 4, 8, 9, 10, 53},
    4: {12, 14, 15, 26, 50},
    5: {51}
}

nejkratsi_kruznice = {
    # pro grafy bez kruznic pouzijte klic None
    # Klicem je pocet hran kruznice.
    None: {9, 10, 12},
    3: {4, 8, 14, 15, 26, 50, 51, 53},
    4: {1, 3, 6},
    5: {2}
}

nejdelsi_kruznice = {
    # pro grafy bez kruznic pouzijte klic None
    # Klicem je pocet hran kruznice.
    None: {9, 10, 12},
    4: {6, 50, 51},
    5: {2, 26},
    6: {1, 8, 14},
    7: {3},
    8: {4, 15, 53}
}

chromaticke_cislo = {
    2: {1, 6, 9, 10, 12},
    3: {2, 3, 4, 8, 14, 15, 26, 50, 51, 53}
}

polomer_grafu = {
    # Klicem je pocet hran.
    1: {50, 51},
    2: {1, 2, 3, 4, 6, 8, 9, 12, 14, 15, 26},
    3: {10, 53}
}

prumer_grafu = {
    # Klicem je pocet hran.
    2: {2, 6, 14, 50, 51},
    3: {1, 3, 8, 9, 26},
    4: {4, 12, 15, 53},
    6: {10}
}

# V ramci reseni teto ulohy jsem si zahral grafove domino s cca 14 dalsimi lidmi, mj. i s panem profesorem Hlinenym, jeho dcerou, moji ctyrletou sestrickou, dalsimi resiteli KSI ...
# Video z akce jsme bohuzel jeste nestihli zpracovat, tak prikladam odkaz na verejny facebookkovy event, na kterem jsou mj. fotky z akce: https://www.facebook.com/events/855582244482903/

# Dale doporucuji k vasi pozornosti prvni dil Fun With Graphs natoceny specialne u prilezitosti teto ulohy:
# https://www.youtube.com/watch?v=AEK-JANUswo

