import Queue

# Pokud se jedna o zizalu, vrati True, jinak False.
def detekuj_zizalu(vrchol):
    # Princip:
    #   Z puvodni hrany jdeme ve dvou smerech a pokud narazime na vrchol
    #   ktery ma vic jak 2 hrany, ci dtekujeme cyklus, vyhlasime, ze zvire
    #   neni zizala.

    # Asymptoticka casova slozitost je O(V), kde V je pocet vrcholu.
    #  Ke kazdemu vrcholu bude pristoupeno nejvyse jedenkrat.

    # Z puvodniho vrcholu muze vychazet 1-2 hrany.
    if not (len(vrchol.sousedi.values()) in range(1, 3)): return False

    # Iterujeme pres hrany, ktere vychazi z puvodniho vrcholu.
    for i in vrchol.sousedi.values():
      # Pri prochazeni linerniho grafu si pamatujeme aktualni a predchozi prvek.
      last    = vrchol
      current = i

      # Zkontrolujeme pocet hran. (tato kontrola tu musi byt!)
      if len(current.sousedi.values()) > 2: return False

      # 0 hran  = v tomto momente by se jednalo o nevalidni graf
      # 1 hrana = ukoncovaci element -> ukoncit while cyklus
      # -> cyklim dokud ma vrchol 2 hrany (tzn. cesta pokracuje)
      while (len(current.sousedi) == 2):
        # Vybereme dalsi hranu (nesmi vest zpet do puvodniho vrcholu)
        #   K urceni zpetne hrany pouzijeme last.
        if current.sousedi.values()[0] == last:
          last = current
          current = current.sousedi.values()[1]
        else:
          last = current
          current = current.sousedi.values()[0]

        # Zkontrolujeme cyklus (cyklus = nevalidni zizala).
        # Tato kontrola cyklu predpoklada jeden velky cyklus, coz je spravny predpoklad,
        #  protoze zbyle cykly jsou odfiltrovany podminkou na pocet hran.
        if current == vrchol: return False

        # Zkontrolujeme pocet hran.
        if len(current.sousedi.values()) > 2: return False

    return True
    
################################################################################

# Vyjimka pro cyklicky graf
class LoopException(Exception):
  def __init__(self, value):
    self.value = value
  def __str__(self):
    return repr(self.value)

# Vraci pocet deti ze zadaneho vrcholu vcetne tohoto vrcholu
# Root je ochrana proti zacykleni
# V pripade cyklu v grafu generuje vyjimku
def child_count(root, sender, vrchol):
  ret = 1
  for i in vrchol.sousedi.values():
    if (i != sender):
      if (i == root): raise LoopException("Loop in graph!")
      ret += child_count(root, vrchol, i)
  return ret

# Vrati takove sousedy vrcholu \vrchol, za kterymi je jeste alespon jeden vrchol.
# Tj. pocet deti > 1
def more_than_one_child(vrchol):
  ret = []
  for i in vrchol.sousedi.values():
    if child_count(vrchol, vrchol, i) > 1: ret.append(i)
  return ret

# Funkce pro detekci housenky.
# Pokud se jedna o housenku, vrati True, jinak False
def detekuj_housenku(vrchol):
    # Princip:
    #   1) Najdeme pater housenky.
    #   2) Prochazime pater a kontorlujeme validitu grafu.

    # Asymptoticka casova slozitost je O(n*V), kde V je pocet vrcholu a n delka patere.

    # Nejdriv najdeme vrchol v potencialni pateri housenky.
    # To je takovy vrchol, ktery ma >1 sousedu.
    if len(vrchol.sousedi.values()) == 0: return False
    if len(vrchol.sousedi.values()) == 1:
      vrchol = vrchol.sousedi.values()[0]

    # Ve Vrchol je ted vrchol patere.
    # Vrchol v pateri musi mit 2-4 sousedu.
    if not len(vrchol.sousedi.values()) in range(1,5): return False

    # Kontrola poctu deti vetsich nez 1 vrchol
    # Vyjimku staci kontrolovat jednou, priste uz nikdy nemuze z principu souvislosti grafu nastat.
    # Cyklicke grafy neberem -> vracime False.
    # Timto jsme zkontrolovali cykly pro cely graf.
    try:
      if len(more_than_one_child(vrchol)) > 2: return False
    except LoopException as e:
      return False

    # Prochazime pater.
    # Rozdelime se na 2 smery.
    for i in more_than_one_child(vrchol):
      last    = vrchol
      current = i
      pater = more_than_one_child(i)

      # Kontrola rozdvojeni patere (tady musi byt!)
      if len(pater) > 2: return False

      # Prochazime pater v jednom smeru
      while (len(pater) == 2):
        if pater[0] == last:
          last    = current
          current = pater[1]
        else:
          last    = current
          current = pater[0]

        # Zkontrolujeme pocet hran.
        if not len(current.sousedi.values()) in range(1,5): return False

        pater = more_than_one_child(current)

        # Kontrola rozdvojeni patere
        if len(pater) > 2: return False

    return True
    
################################################################################

# Pokud se jedna o pavouka, vrati True, jinak False.
def detekuj_pavouka(vrchol):
    # Pricnip:
    # 1) Nalezneme stred pavouka.
    # 2) Na vetve postveme kontrolni algoritmus "zizala".

    # Asymptoticka casova slozitost je O(V), kde V je pocet vrcholu.
    #  Ve skutecnosti neco mezi V --- (2*V)
    #  1*V je algoritmus "zizala"
    #  1*V je maxialni slozitost algoritmu pro nalezeni stredu pavouka.
    #     Slozitost tohoto algoritmu se ale hodne lisi od tvaru vstupniho grafu.
    #     Vstupni graf muze byt hodne linearni, nebo naopak hodne vetveny.
    #     Prochazeni linerniho grafu napr. od uplneho konce by trvalo docela dlouho.

    # ---------------------------------------------------------------
    # Stred pavouka je takovy vrchol, ze ktereho vede vic jak 2 hrany.
    # I kdyz je to trochu mene prehledne, pro hledani stredu jsem zvolil
    #   nerekurzivni algoritmus.
    if len(vrchol.sousedi.values()) == 0: return False

    if len(vrchol.sousedi) > 2:
      root = vrchol
    else:
      root = None

      for i in vrchol.sousedi.values():
        last    = vrchol
        current = i

        while (len(current.sousedi) == 2):
          # Vybereme dalsi hranu (nesmi vest zpet do puvodniho vrcholu)
          #   K urceni zpetne hrany pouzijeme last.
          if current.sousedi.values()[0] == last:
            last = current
            current = current.sousedi.values()[1]
          else:
            last = current
            current = current.sousedi.values()[0]

          # kontrola zacykleni
          if current == vrchol: return False

        if len(current.sousedi) > 2:
          root = current
          break

      if root is None: return False

    # ---------------------------------------------------------------
    # Nyni mame stred -> smazeme cesty k sousedum a sousedy kontrolujeme jako zizaly.
    for i in root.sousedi.values():
      del i.sousedi[root.nazev]
      if not detekuj_zizalu(i):

        # vratime zpet znicene vazby
        for i in root.sousedi.values():
          i.sousedi[root.nazev] = root

        return False

    # vratime zpet znicene vazby
    for i in root.sousedi.values():
      i.sousedi[root.nazev] = root

    return True
    
################################################################################

# Pokud se jedna o broucka, vrati True, jinak False.
def detekuj_broucka(vrchol):
    # Princip: vybereme si jeden smer a timto smerem jdeme
    #  dokud nenarazime na puvodni vrchol
    #  Jelikoz predpokladame cyklus, je uplne jedno, jaky smer zvolime.

    # Pruchod tak, jak ho implementujeme (pomoci current a last) nam zaroven
    #  zajistuje to, ze cyklus delky 2 nebude bran jako validni cyklus.

    # Asymptoticka casova slozitost je O(V), kde V je pocet vrcholu.
    #  Ke kazdemu vrcholu bude pristoupeno nejvyse jedenkrat.

    if len(vrchol.sousedi) == 0: return False
    last    = vrchol
    current = vrchol.sousedi.values()[0]
    while current != vrchol:
      if current.sousedi.values()[0] == last:
        last = current
        current = current.sousedi.values()[1]
      else:
        last = current
        current = current.sousedi.values()[0]

      if len(current.sousedi) > 2: return False

    return True
    
################################################################################

# Pokud se jedna o larvu, vrati True, jinak False.
def detekuj_larvu(vrchol):
    # Princip: provedeme prohledan=vani do sirky a porovnavame pocet hran
    #  Pocet hran musi byt vsude stejny.
    #  Toto prohledavani nejde delat jednoduseji (bez oznaceni vrcholu),
    #  protoze v grafu se mohou vyskytovat cykly.

    # Asymptoticka casova slozistost je O(V), kde V je pocet vrcholu.
    #  Ke kazdemu vrcholu bude pristoupeno nejvyse jedenkrat.

    # Vhodime \vrchol do fronty.
    vrchol.barva = True
    cnt = len(vrchol.sousedi)
    q = Queue.Queue()
    q.put(vrchol)

    # Prochazime vrcholy ve fronte dokud neni fronta prazdna.
    # V barve vrcholu si pamatujeme jestli jsme ho navstivili.
    while not q.empty():
      vrchol = q.get()
      if cnt != len(vrchol.sousedi): return False
      for i in vrchol.sousedi.values():
        if i.barva is None:
          i.barva = True
          q.put(i)

    return True

################################################################################

# S vyuzitim vyse uvedenych funkci vrati cislo zvirete.
def detekuj_zvire(vrchol):
    if detekuj_zizalu(vrchol)     : return 1
    elif detekuj_housenku(vrchol) : return 2
    elif detekuj_pavouka(vrchol)  : return 3
    elif detekuj_broucka(vrchol)  : return 4
    elif detekuj_larvu(vrchol)    : return 5
    else                          : return 0

################################################################################
